# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: users
#
#  id                    :integer       not null, primary key
#  domain_id             :integer       not null
#  person_id             :integer       not null
#  login                 :string(80)    not null
#  salted_password       :string(128)   not null
#  admin                 :boolean       not null
#  list_default_per_page :integer       default(10), not null
#  list_header_per_line  :integer       default(10), not null
#  menu_history_max      :integer       default(10), not null
#  salt                  :string(128)   not null
#  verified              :boolean       not null
#  security_token        :string(128)
#  token_expiry          :datetime
#  deleted               :boolean       not null
#  failed_login_count    :integer       default(0), not null
#  password_updated_on   :string(8)
#  created_at            :string(14)
#  updated_at            :string(14)
#  created_by            :integer
#  updated_by            :integer
#  created_in            :integer
#  updated_in            :integer
#  lock_version          :integer       default(0), not null
#

require "digest/sha2"

# ユーザーのモデル
# this model expects a certain database layout and its based on the name/login pattern.
class User < ActiveRecord::Base
  PasswordDigestClass = Digest::SHA512

  def initialize(attributes = nil)
    super
  end

  # <em>login</em> と <em>pass</em> による認証を行う。
  # 成功した場合は <tt>nil</tt> でない値、失敗した場合は <tt>nil</tt> を返す。
  def self.authenticate(login, pass, update_failed_login_count=false)
    User.transaction do
      u = find( :first, :conditions => ["login = ? AND verified = ? AND deleted = ?", login, true, false])
      return nil if u.nil?
      if u.salted_password == salted_password(u.salt, hashed(pass)) then
        return u
      else
        return nil
      end
    end
  end

  # <em>str</em> をハッシュ化する。
  def self.hashed(str)
    return PasswordDigestClass.hexdigest("#{UserSystem::CONFIG[:password_hash_prefix]}--#{str}--")[0,128]
  end

   # <em>salt</em> と <em>hashed_password</em> をハッシュ化する。
  def self.salted_password(salt, hashed_password)
    hashed(salt + hashed_password)
  end
end
